//var 134 is storage chest

/*
SceneManager.push(Scene_Storage);
*/

function Scene_Storage() {
    this.initialize.apply(this, arguments);
}

Scene_Storage.prototype = Object.create(Scene_MenuBase.prototype);
Scene_Storage.prototype.constructor = Scene_Storage;

Scene_Storage.prototype.initialize = function() {
    Scene_MenuBase.prototype.initialize.call(this);
};

Scene_Storage.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);
	
    this._storageWindow = new Window_StorageItem();
    this._storageWindow.setHandler('select',   this.onOk.bind(this));
    this._storageWindow.setHandler('cancel',   this.onCancel.bind(this));
    this.addWindow(this._storageWindow);
	
    this._retrieveWindow = new Window_RetrieveItem();
    this._retrieveWindow.setHandler('select',   this.onOk.bind(this));
    this._retrieveWindow.setHandler('cancel',   this.onCancel.bind(this));
    this.addWindow(this._retrieveWindow);
	
	this._helpWindow = new Window_Help();
	this.addWindow(this._helpWindow);
	this._storageWindow.setHelpWindow(this._helpWindow);
	this._retrieveWindow.setHelpWindow(this._helpWindow);
	
	this._storageWindow.partner = this._retrieveWindow
	this._retrieveWindow.partner = this._storageWindow
	
	this._helpWindow.visible = true
	$gameVariables.setValue(1, 0)
	$gameVariables.setValue(2, 0)
	
	this._retrieveWindow.refresh();
	this._storageWindow.start()

	if (ConfigManager.touchbuttons) {
		this.sprite1U = new Sprite(ImageManager.loadPicture('zBtnPrevNextStorage1U'))
		this.sprite1U.visible = false
		this.addChild(this.sprite1U)
		
		this.sprite1D = new Sprite(ImageManager.loadPicture('zBtnPrevNextStorage1D'))
		this.sprite1D.visible = false
		this.addChild(this.sprite1D)
		
		this.sprite2U = new Sprite(ImageManager.loadPicture('zBtnPrevNextStorage2U'))
		this.sprite2U.visible = false
		this.addChild(this.sprite2U)
		
		this.sprite2D = new Sprite(ImageManager.loadPicture('zBtnPrevNextStorage2D'))
		this.sprite2D.visible = false
		this.addChild(this.sprite2D)
		
		this.spriteBack = new Sprite(ImageManager.loadPicture('zBtnBack'))
		this.spriteBack.x = -ConfigManager.movebtn //move x
		this.addChild(this.spriteBack)

	}

};

Scene_Storage.prototype.stop = function() {
    Scene_MenuBase.prototype.stop.call(this);
};

Scene_Storage.prototype.onOk = function() {
};

Scene_Storage.prototype.onCancel = function() {
	$gameScreen.erasePicture(456);
	$gameScreen.erasePicture(128)
	$gameScreen.erasePicture(564)
	$gameScreen.erasePicture(565)
	$gameScreen.erasePicture(566)
	this.popScene();
};


Scene_Storage.prototype.createBackground = function() {
    this._backgroundSprite = new Sprite();
    this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
    this.addChild(this._backgroundSprite);
		
    var width = Graphics.boxWidth;
    var height = Graphics.boxHeight;
    var x = (Graphics.width - width) / 2;
    var y = (Graphics.height - height) / 2;
    this._pictureContainer = new Sprite();
    this._pictureContainer.setFrame(x, y, width, height);
    for (var i = 1; i <= $gameScreen.maxPictures(); i++) {
        this._pictureContainer.addChild(new Sprite_Picture(i));
    }
    this.addChild(this._pictureContainer);
};







function Window_StorageItem() {
    this.initialize.apply(this, arguments);
}

Window_StorageItem.prototype = Object.create(Window_EventItem.prototype);
Window_StorageItem.prototype.constructor = Window_StorageItem;


Window_StorageItem.prototype.maxCols = function() {
    return 1;
};

Window_StorageItem.prototype.initialize = function() {
    Window_ItemList.prototype.initialize.call(this, 62, 28, 346, 448);
    this.setHandler('ok',     this.onOk.bind(this));
    this.setHandler('cancel', this.onCancel.bind(this));
};



Window_StorageItem.prototype.updatePlacement = function() {
};

Window_StorageItem.prototype.makeItemList = function() {
	this._data = $gameParty.allItems().filter(function(item) {
		return this.includes(item);
	}, this);

    if (this.includes(null)) {
        this._data.push(null);
    }
};


Window_StorageItem.prototype.drawItemNumber = function(item, x, y, width) {
	if (this.needsNumber()) {
		if (Utils.isMobileDevice()) {this.contents.fontSize = 20}
		this.drawText('x' + $gameParty.numItems(item), x, y + 16, width, 'right');
	}
};



Window_StorageItem.prototype.includes = function(item) {
	return DataManager.isArmor(item)
};

Window_StorageItem.prototype.onOk = function() {
	var item = this.item();
	var itemId = item ? item.id : 0;
//	if (item) {	SoundManager.playOk()}
//	else {SoundManager.playBuzzer()}
	
	if (item) {
		$gameParty.gainItem(item, -1)
		$gameVariables.value(134).push(itemId)
	}
	
	this.refresh()
	this.partner.refresh();
	this.activate()
	
	if (!this.item()) {
		this.select(Math.max(this.index() - 1, 0));
	}
};


Scene_Storage.prototype.update = function() {
	var item
	if (this._storageWindow.active) {
		item = this._storageWindow._data[this._storageWindow.index()]
	}
	else if ((this._retrieveWindow.active)) {
		item = this._retrieveWindow._data[this._retrieveWindow.index()]
	}
	if (!Utils.isMobileDevice()) {
		if (Input.isRepeated('left') || Input.isRepeated('right')) {
			SoundManager.playCursor();
			$gameScreen.erasePicture(128)
			$gameScreen.erasePicture(564)
			$gameScreen.erasePicture(565)
			$gameScreen.erasePicture(566)
			if (this._storageWindow.active) {
				$gameVariables.setValue(1, this._storageWindow.index())
				this._storageWindow.deactivate()
				
				this._retrieveWindow.activate()
				
				if ($gameVariables.value(2) <= this._retrieveWindow._data.length) {
					this._retrieveWindow.select($gameVariables.value(2))
				}
				else {
					this._retrieveWindow.select(Math.max(this._retrieveWindow._data.length - 1, 0))
				}
				this._retrieveWindow.setHelpWindowItem(item);
			}
			else if ((this._retrieveWindow.active)) {
				$gameVariables.setValue(2, this._retrieveWindow.index())
				this._retrieveWindow.deactivate()
				
				this._storageWindow.activate()
				
				if ($gameVariables.value(1) <= this._storageWindow._data.length) {
					this._storageWindow.select($gameVariables.value(1))
				}
				else {
					this._storageWindow.select(Math.max(this._storageWindow._data.length - 1, 0))
				}
				this._storageWindow.setHelpWindowItem(item);
			}
		}
		else if ($gameVariables.value(207) >= 63 && $gameVariables.value(207) <= 407 &&
				 $gameVariables.value(208) >= 29 && $gameVariables.value(208) <= 475 &&
				 !this._storageWindow.active) {
			this._storageWindow.activate()
			this._retrieveWindow.deactivate()
		}
		else if ($gameVariables.value(207) >= 408 && $gameVariables.value(207) <= 753 &&
				 $gameVariables.value(208) >= 29 && $gameVariables.value(208) <= 475 &&
				 !this._retrieveWindow.active) {
			this._retrieveWindow.activate()
			this._storageWindow.deactivate()
		}
	}
	
	if (DataManager.isArmor(item)) {
		previewclothes(item.etypeId - 2, item.note.match(/<filename:\s*(.*)>/i)[1], false, item.id)
	}
	else {
		$gameScreen.erasePicture(564)
		$gameScreen.erasePicture(565)
		$gameScreen.erasePicture(566)
		$gameScreen.erasePicture(128)
	}
	
	if (ConfigManager.touchbuttons && this._retrieveWindow) {
		var topRow = this._retrieveWindow.topRow();
		var maxTopRow = this._retrieveWindow.maxTopRow();
		if (topRow > 0) {
			this.sprite2U.visible = true
		}
		else {
			this.sprite2U.visible = false
		}
		if (maxTopRow > 0 && topRow < maxTopRow) {
			this.sprite2D.visible = true
		}
		else {
			this.sprite2D.visible = false
		}
	}
	
	if (ConfigManager.touchbuttons && this._storageWindow) {
		var topRow = this._storageWindow.topRow();
		var maxTopRow = this._storageWindow.maxTopRow();
		if (topRow > 0) {
			this.sprite1U.visible = true
		}
		else {
			this.sprite1U.visible = false
		}
		if (maxTopRow > 0 && topRow < maxTopRow) {
			this.sprite1D.visible = true
		}
		else {
			this.sprite1D.visible = false
		}
	}
	
    Scene_MenuBase.prototype.update.call(this);
};




Window_StorageItem.prototype.processCursorMove = function() {
    if (this.isCursorMovable()) {
        var lastIndex = this.index();
        if (Input.isRepeated('down')) {
            this.cursorDown(Input.isTriggered('down'));
        }
        if (Input.isRepeated('up')) {
            this.cursorUp(Input.isTriggered('up'));
        }
        if (Input.isRepeated('right')) {
            this.cursorRight(Input.isTriggered('right'));
        }
        if (Input.isRepeated('left')) {
            this.cursorLeft(Input.isTriggered('left'));
        }
        if (!this.isHandled('pagedown') && Input.isRepeated('pagedown')) {
            this.cursorPagedown();
        }
        if (!this.isHandled('pageup') && Input.isRepeated('pageup')) {
            this.cursorPageup();
        }
        if (this.index() !== lastIndex) {
            SoundManager.playCursor();
        }
    }
};



function Window_RetrieveItem() {
    this.initialize.apply(this, arguments);
}

Window_RetrieveItem.prototype = Object.create(Window_StorageItem.prototype);
Window_RetrieveItem.prototype.constructor = Window_RetrieveItem;

Window_RetrieveItem.prototype.initialize = function() {
    Window_ItemList.prototype.initialize.call(this, 407, 28, 347, 448);
    this.setHandler('ok',     this.onOk.bind(this));
    this.setHandler('cancel', this.onCancel.bind(this));
};


Window_RetrieveItem.prototype.makeItemList = function() {
	this._data = $dataArmors.filter(function(item) {
		return this.includes(item);
	}, this);
	
    if (this.includes(null)) {
        this._data.push(null);
    }
};



Window_RetrieveItem.prototype.drawItemNumber = function(item, x, y, width) {
	if (Utils.isMobileDevice()) {this.contents.fontSize = 20}
	var count = 0
	for (var i = 0; i < $gameVariables.value(134).length; i++) {
		if (item.id == $gameVariables.value(134)[i]) {
			count += 1
		}
	}
	this.drawText('x' + count, x, y + 16, width, 'right');
};

Window_RetrieveItem.prototype.includes = function(item) {
	if (item) {return $gameVariables.value(134).includes(item.id)}
};


Window_RetrieveItem.prototype.onOk = function() {
	var item = this.item();
	var itemId = item ? item.id : 0;
	
//	if (item) {	SoundManager.playOk()}
//	else {SoundManager.playBuzzer()}
	
	if (item) {
		$gameParty.gainItem(item, 1)
		
		for (var i = 0; i < $gameVariables.value(134).length; i++) {
			if (item.id == $gameVariables.value(134)[i]) {
				$gameVariables.value(134).splice(i, 1);
				break
			}
		}
	}
	
	this.refresh()
	this.partner.refresh();
	this.activate()
	
	if (!this.item()) {
		this.select(Math.max(this.index() - 1, 0));
	}
	
	
};

